﻿'**********************************************************************************
'* クラス名        ：DaoProducts
'* クラス日本語名  ：自動生成Ｄａｏクラス
'*
'* 作成日時        ：2014/2/9
'* 作成者          ：棟梁 D層自動生成ツール（墨壺）, 日立 太郎
'* 更新履歴        ：
'*
'*  日時        更新者            内容
'*  ----------  ----------------  -------------------------------------------------
'*  20xx/xx/xx  ＸＸ ＸＸ         ＸＸＸＸ
'*  2012/06/14  西野  大介        ResourceLoaderに加え、EmbeddedResourceLoaderに対応
'*  2013/09/09  西野  大介        ExecGenerateSQLメソッドを追加した（バッチ更新用）。
'**********************************************************************************

#Region "using"

' System～
Imports System
Imports System.IO
Imports System.Data
Imports System.Collections

' フレームワーク
Imports Touryo.Infrastructure.Framework.Dao
Imports Touryo.Infrastructure.Framework.Common

' 部品
Imports Touryo.Infrastructure.Public.Db
Imports Touryo.Infrastructure.Public.Util

' 業務フレームワーク
Imports Touryo.Infrastructure.Business.Dao

#End Region

''' <summary>自動生成Ｄａｏクラス</summary>
Public Class DaoProducts
	Inherits MyBaseDao
	#Region "インスタンス変数"

	''' <summary>ユーザ パラメタ（文字列置換）用ハッシュ テーブル</summary>
	Protected HtUserParameter As New Hashtable()
	''' <summary>パラメタ ライズド クエリのパラメタ用ハッシュ テーブル</summary>
	Protected HtParameter As New Hashtable()

	#End Region

	#Region "コンストラクタ"

	''' <summary>コンストラクタ</summary>
	Public Sub New(dam As BaseDam)
		MyBase.New(dam)
	End Sub

	#End Region

	#Region "共通関数（パラメタの制御）"

	''' <summary>ユーザ パラメタ（文字列置換）をハッシュ テーブルに設定する。</summary>
	''' <param name="userParamName">ユーザ パラメタ名</param>
	''' <param name="userParamValue">ユーザ パラメタ値</param>
	Public Sub SetUserParameteToHt(userParamName As String, userParamValue As String)
		' ユーザ パラメタをハッシュ テーブルに設定
		Me.HtUserParameter(userParamName) = userParamValue
	End Sub

	''' <summary>パラメタ ライズド クエリのパラメタをハッシュ テーブルに設定する。</summary>
	''' <param name="paramName">パラメタ名</param>
	''' <param name="paramValue">パラメタ値</param>
	Public Sub SetParameteToHt(paramName As String, paramValue As Object)
		' ユーザ パラメタをハッシュ テーブルに設定
		Me.HtParameter(paramName) = paramValue
	End Sub

	''' <summary>
	''' ・ユーザ パラメタ（文字列置換）
	''' ・パラメタ ライズド クエリのパラメタ
	''' を格納するハッシュ テーブルをクリアする。
	''' </summary>
	Public Sub ClearParametersFromHt()
		' ユーザ パラメタ（文字列置換）用ハッシュ テーブルを初期化
		Me.HtUserParameter = New Hashtable()
		' パラメタ ライズド クエリのパラメタ用ハッシュ テーブルを初期化
		Me.HtParameter = New Hashtable()
	End Sub

	''' <summary>パラメタの設定（内部用）</summary>
	Protected Sub SetParametersFromHt()
		' ユーザ パラメタ（文字列置換）を設定する。
		For Each userParamName As String In Me.HtUserParameter.Keys
			Me.SetUserParameter(userParamName, Me.HtUserParameter(userParamName).ToString())
		Next

		' パラメタ ライズド クエリのパラメタを設定する。
		For Each paramName As String In Me.HtParameter.Keys
			Me.SetParameter(paramName, Me.HtParameter(paramName))
		Next
	End Sub

	#End Region

	#Region "プロパティ プロシージャ（setter、getter）"


	''' <summary>ProductID列（主キー列）に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property PK_ProductID() As Object
		Get
			Return Me.HtParameter("ProductID")
		End Get
		Set
			Me.HtParameter("ProductID") = value
		End Set
	End Property



	''' <summary>ProductName列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property ProductName() As Object
		Get
			Return Me.HtParameter("ProductName")
		End Get
		Set
			Me.HtParameter("ProductName") = value
		End Set
	End Property

	''' <summary>SupplierID列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property SupplierID() As Object
		Get
			Return Me.HtParameter("SupplierID")
		End Get
		Set
			Me.HtParameter("SupplierID") = value
		End Set
	End Property

	''' <summary>CategoryID列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property CategoryID() As Object
		Get
			Return Me.HtParameter("CategoryID")
		End Get
		Set
			Me.HtParameter("CategoryID") = value
		End Set
	End Property

	''' <summary>QuantityPerUnit列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property QuantityPerUnit() As Object
		Get
			Return Me.HtParameter("QuantityPerUnit")
		End Get
		Set
			Me.HtParameter("QuantityPerUnit") = value
		End Set
	End Property

	''' <summary>UnitPrice列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property UnitPrice() As Object
		Get
			Return Me.HtParameter("UnitPrice")
		End Get
		Set
			Me.HtParameter("UnitPrice") = value
		End Set
	End Property

	''' <summary>UnitsInStock列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property UnitsInStock() As Object
		Get
			Return Me.HtParameter("UnitsInStock")
		End Get
		Set
			Me.HtParameter("UnitsInStock") = value
		End Set
	End Property

	''' <summary>UnitsOnOrder列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property UnitsOnOrder() As Object
		Get
			Return Me.HtParameter("UnitsOnOrder")
		End Get
		Set
			Me.HtParameter("UnitsOnOrder") = value
		End Set
	End Property

	''' <summary>ReorderLevel列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property ReorderLevel() As Object
		Get
			Return Me.HtParameter("ReorderLevel")
		End Get
		Set
			Me.HtParameter("ReorderLevel") = value
		End Set
	End Property

	''' <summary>Discontinued列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタを除く</remarks>
	Public Property Discontinued() As Object
		Get
			Return Me.HtParameter("Discontinued")
		End Get
		Set
			Me.HtParameter("Discontinued") = value
		End Set
	End Property


	''' <summary>Set_ProductID_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_ProductID_forUPD() As Object
		Get
			Return Me.HtParameter("Set_ProductID_forUPD")
		End Get
		Set
			Me.HtParameter("Set_ProductID_forUPD") = value
		End Set
	End Property


	''' <summary>Set_ProductName_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_ProductName_forUPD() As Object
		Get
			Return Me.HtParameter("Set_ProductName_forUPD")
		End Get
		Set
			Me.HtParameter("Set_ProductName_forUPD") = value
		End Set
	End Property


	''' <summary>Set_SupplierID_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_SupplierID_forUPD() As Object
		Get
			Return Me.HtParameter("Set_SupplierID_forUPD")
		End Get
		Set
			Me.HtParameter("Set_SupplierID_forUPD") = value
		End Set
	End Property


	''' <summary>Set_CategoryID_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_CategoryID_forUPD() As Object
		Get
			Return Me.HtParameter("Set_CategoryID_forUPD")
		End Get
		Set
			Me.HtParameter("Set_CategoryID_forUPD") = value
		End Set
	End Property


	''' <summary>Set_QuantityPerUnit_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_QuantityPerUnit_forUPD() As Object
		Get
			Return Me.HtParameter("Set_QuantityPerUnit_forUPD")
		End Get
		Set
			Me.HtParameter("Set_QuantityPerUnit_forUPD") = value
		End Set
	End Property


	''' <summary>Set_UnitPrice_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_UnitPrice_forUPD() As Object
		Get
			Return Me.HtParameter("Set_UnitPrice_forUPD")
		End Get
		Set
			Me.HtParameter("Set_UnitPrice_forUPD") = value
		End Set
	End Property


	''' <summary>Set_UnitsInStock_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_UnitsInStock_forUPD() As Object
		Get
			Return Me.HtParameter("Set_UnitsInStock_forUPD")
		End Get
		Set
			Me.HtParameter("Set_UnitsInStock_forUPD") = value
		End Set
	End Property


	''' <summary>Set_UnitsOnOrder_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_UnitsOnOrder_forUPD() As Object
		Get
			Return Me.HtParameter("Set_UnitsOnOrder_forUPD")
		End Get
		Set
			Me.HtParameter("Set_UnitsOnOrder_forUPD") = value
		End Set
	End Property


	''' <summary>Set_ReorderLevel_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_ReorderLevel_forUPD() As Object
		Get
			Return Me.HtParameter("Set_ReorderLevel_forUPD")
		End Get
		Set
			Me.HtParameter("Set_ReorderLevel_forUPD") = value
		End Set
	End Property


	''' <summary>Set_Discontinued_forUPD列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>更新処理時のSET句で使用するパラメタ専用</remarks>
	Public Property Set_Discontinued_forUPD() As Object
		Get
			Return Me.HtParameter("Set_Discontinued_forUPD")
		End Get
		Set
			Me.HtParameter("Set_Discontinued_forUPD") = value
		End Set
	End Property



	''' <summary>ProductID_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property ProductID_Like() As Object
		Get
			Return Me.HtParameter("ProductID_Like")
		End Get
		Set
			Me.HtParameter("ProductID_Like") = value
		End Set
	End Property


	''' <summary>ProductName_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property ProductName_Like() As Object
		Get
			Return Me.HtParameter("ProductName_Like")
		End Get
		Set
			Me.HtParameter("ProductName_Like") = value
		End Set
	End Property


	''' <summary>SupplierID_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property SupplierID_Like() As Object
		Get
			Return Me.HtParameter("SupplierID_Like")
		End Get
		Set
			Me.HtParameter("SupplierID_Like") = value
		End Set
	End Property


	''' <summary>CategoryID_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property CategoryID_Like() As Object
		Get
			Return Me.HtParameter("CategoryID_Like")
		End Get
		Set
			Me.HtParameter("CategoryID_Like") = value
		End Set
	End Property


	''' <summary>QuantityPerUnit_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property QuantityPerUnit_Like() As Object
		Get
			Return Me.HtParameter("QuantityPerUnit_Like")
		End Get
		Set
			Me.HtParameter("QuantityPerUnit_Like") = value
		End Set
	End Property


	''' <summary>UnitPrice_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property UnitPrice_Like() As Object
		Get
			Return Me.HtParameter("UnitPrice_Like")
		End Get
		Set
			Me.HtParameter("UnitPrice_Like") = value
		End Set
	End Property


	''' <summary>UnitsInStock_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property UnitsInStock_Like() As Object
		Get
			Return Me.HtParameter("UnitsInStock_Like")
		End Get
		Set
			Me.HtParameter("UnitsInStock_Like") = value
		End Set
	End Property


	''' <summary>UnitsOnOrder_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property UnitsOnOrder_Like() As Object
		Get
			Return Me.HtParameter("UnitsOnOrder_Like")
		End Get
		Set
			Me.HtParameter("UnitsOnOrder_Like") = value
		End Set
	End Property


	''' <summary>ReorderLevel_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property ReorderLevel_Like() As Object
		Get
			Return Me.HtParameter("ReorderLevel_Like")
		End Get
		Set
			Me.HtParameter("ReorderLevel_Like") = value
		End Set
	End Property


	''' <summary>Discontinued_Like列に対するパラメタ ライズド クエリのパラメタを設定する。</summary>
	''' <remarks>動的参照処理時のLIKE検索で使用するパラメタ専用</remarks>
	Public Property Discontinued_Like() As Object
		Get
			Return Me.HtParameter("Discontinued_Like")
		End Get
		Set
			Me.HtParameter("Discontinued_Like") = value
		End Set
	End Property


	#End Region

	#Region "クエリ メソッド"

	#Region "Insert"

	''' <summary>１レコード挿入する。</summary>
	''' <returns>挿入された行の数</returns>
	Public Function S1_Insert() As Integer
		' ファイルからSQL（Insert）を設定する。
		Me.SetSqlByFile2("DaoProducts_S1_Insert.sql")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（Insert）を実行し、戻り値を戻す。
		Return Me.ExecInsUpDel_NonQuery()
	End Function

	''' <summary>１レコード挿入する。</summary>
	''' <returns>挿入された行の数</returns>
	''' <remarks>パラメタで指定した列のみ挿入値が有効になる。</remarks>
	Public Function D1_Insert() As Integer
		' ファイルからSQL（DynIns）を設定する。
		Me.SetSqlByFile2("DaoProducts_D1_Insert.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（DynIns）を実行し、戻り値を戻す。
		Return Me.ExecInsUpDel_NonQuery()
	End Function

	#End Region

	#Region "Select"

	''' <summary>主キーを指定し、１レコード参照する。</summary>
	''' <param name="dt">結果を格納するDataTable</param>
	Public Sub S2_Select(dt As DataTable)
		' ファイルからSQL（Select）を設定する。
		Me.SetSqlByFile2("DaoProducts_S2_Select.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（Select）を実行し、戻り値を戻す。
		Me.ExecSelectFill_DT(dt)
	End Sub

	''' <summary>検索条件を指定し、結果セットを参照する。</summary>
	''' <param name="dt">結果を格納するDataTable</param>
	Public Sub D2_Select(dt As DataTable)
		' ファイルからSQL（DynSel）を設定する。
		Me.SetSqlByFile2("DaoProducts_D2_Select.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（DynSel）を実行し、戻り値を戻す。
		Me.ExecSelectFill_DT(dt)
	End Sub

	#End Region

	#Region "Update"

	''' <summary>主キーを指定し、１レコード更新する。</summary>
	''' <returns>更新された行の数</returns>
	''' <remarks>パラメタで指定した列のみ更新値が有効になる。</remarks>
	Public Function S3_Update() As Integer
		' ファイルからSQL（Update）を設定する。
		Me.SetSqlByFile2("DaoProducts_S3_Update.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（Update）を実行し、戻り値を戻す。
		Return Me.ExecInsUpDel_NonQuery()
	End Function

	''' <summary>任意の検索条件でデータを更新する。</summary>
	''' <returns>更新された行の数</returns>
	''' <remarks>パラメタで指定した列のみ更新値が有効になる。</remarks>
	Public Function D3_Update() As Integer
		' ファイルからSQL（DynUpd）を設定する。
		Me.SetSqlByFile2("DaoProducts_D3_Update.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（DynUpd）を実行し、戻り値を戻す。
		Return Me.ExecInsUpDel_NonQuery()
	End Function

	#End Region

	#Region "Delete"

	''' <summary>主キーを指定し、１レコード削除する。</summary>
	''' <returns>削除された行の数</returns>
	Public Function S4_Delete() As Integer
		' ファイルからSQL（Delete）を設定する。
		Me.SetSqlByFile2("DaoProducts_S4_Delete.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（Delete）を実行し、戻り値を戻す。
		Return Me.ExecInsUpDel_NonQuery()
	End Function

	''' <summary>任意の検索条件でデータを削除する。</summary>
	''' <returns>削除された行の数</returns>
	Public Function D4_Delete() As Integer
		' ファイルからSQL（DynDel）を設定する。
		Me.SetSqlByFile2("DaoProducts_D4_Delete.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（DynDel）を実行し、戻り値を戻す。
		Return Me.ExecInsUpDel_NonQuery()
	End Function

	#End Region

	#Region "拡張メソッド"

	''' <summary>テーブルのレコード件数を取得する</summary>
	''' <returns>テーブルのレコード件数</returns>
	Public Function D5_SelCnt() As Object
		' ファイルからSQL（DynSelCnt）を設定する。
		Me.SetSqlByFile2("DaoProducts_D5_SelCnt.xml")

		' パラメタの設定
		Me.SetParametersFromHt()

		' SQL（SELECT COUNT）を実行し、戻り値を戻す。
		Return Me.ExecSelectScalar()
	End Function

	''' <summary>静的SQLを生成する。</summary>
	''' <param name="fileName">ファイル名</param>
	''' <param name="sqlUtil">SQLユーティリティ</param>
	''' <returns>生成した静的SQL</returns>
	Public Overloads Function ExecGenerateSQL(fileName As String, sqlUtil As SQLUtility) As String
		' ファイルからSQLを設定する。
		Me.SetSqlByFile2(fileName)

		' パラメタの設定
		Me.SetParametersFromHt()

		Return MyBase.ExecGenerateSQL(sqlUtil)
	End Function

	#End Region

	#End Region
End Class
